<?php

defined( 'ABSPATH' ) || exit;


?>

<div class="radio-player-getting-started">
    <div class="getting-started-header">
        <div class="header-logo">
            <img src="<?php echo RADIO_PLAYER_ASSETS . '/images/radio-player-logo.png'; ?>">
            <span><?php esc_html_e( 'Radio Player', 'radio-player' ); ?></span>
        </div>
        <p><?php esc_html_e( 'Live Shoutcast, Icecast and Audio Stream Player for WordPress', 'radio-player' ); ?></p>
        <h2 class="header-title"><?php esc_html_e( 'Getting Started', 'radio-player' ); ?></h2>
    </div>

    <div class="getting-started-main">

        <div class="getting-started-menu">
            <div class="menu-item active" data-target="introduction">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_1287_15136)">
                        <path d="M11.9795 24C9.51917 24 7.16112 23.2021 4.96674 21.6216C3.09462 20.2728 1.70843 18.5122 0.854211 16.3912C0.0511416 14.4093 -0.184153 12.314 0.143213 10.1622C0.884901 5.30759 4.52684 1.44144 9.42199 0.30888C10.3018 0.10296 11.2072 0 12.1023 0C14.5064 0 16.8286 0.725869 18.8184 2.10039C20.8337 3.49035 22.358 5.45174 23.2327 7.76319C23.734 9.09653 23.9949 10.5225 24 11.9949C24 14.6203 23.1253 17.2149 21.5447 19.2999C20.7621 20.3346 19.821 21.2252 18.757 21.9459C17.6624 22.6873 16.4603 23.2381 15.1867 23.5727C14.1023 23.8559 13.023 24 11.9795 24ZM11.9795 1.45174C11.9284 1.45174 11.8772 1.45174 11.8261 1.45174C6.10229 1.53411 1.4936 6.30116 1.55498 12.0875C1.61636 17.9254 6.20459 22.4968 12.0051 22.5019H12.0409C14.89 22.5019 17.6726 21.3179 19.6726 19.2587C21.6419 17.2252 22.6905 14.5483 22.6189 11.722C22.4655 5.96139 17.7954 1.45174 11.9795 1.45174Z"
                              fill="#0E0E0E"/>
                        <path d="M13.529 19.9944C12.506 19.9944 11.4983 19.9944 10.4702 19.9944C10.4702 16.1643 10.4702 12.3548 10.4702 8.51953C11.483 8.51953 12.4907 8.51953 13.529 8.51953C13.529 12.3342 13.529 16.1489 13.529 19.9944Z"
                              fill="#0E0E0E"/>
                        <path d="M10.3477 5.60594C10.3528 4.669 11.0587 3.99976 12.0408 4.00491C12.941 4.01006 13.6623 4.72563 13.6571 5.61624C13.652 6.52229 12.9257 7.24301 12.0203 7.24301C11.0638 7.23786 10.3426 6.53773 10.3477 5.60594Z"
                              fill="#0E0E0E"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_1287_15136">
                            <rect width="24" height="24" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>
                <span><?php esc_html_e( 'Introduction', 'radio-player' ); ?></span>
            </div>

            <div class="menu-item" data-target="what-new">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M4.09836 20.4924C3.37761 20.4719 2.78595 20.2061 2.31261 19.6845C1.36595 18.621 0.645201 17.4349 0.161114 16.1259C-0.172369 15.2261 -0.0217641 14.3671 0.752776 13.7536C1.94686 12.8026 1.9361 11.1869 0.752776 10.2461C-0.0217641 9.6121 -0.172369 8.73268 0.171871 7.82258C0.655959 6.53413 1.38747 5.35816 2.32337 4.31513C2.95807 3.60954 3.79715 3.30277 4.73305 3.61977C6.38971 4.17197 7.7344 3.21074 7.99258 1.82003C8.15394 0.940606 8.79939 0.388412 9.7353 0.214573C11.2306 -0.0717499 12.7259 -0.0717499 14.2212 0.204347C15.1894 0.388412 15.781 0.981509 16.0392 1.88138C16.491 3.48684 17.5345 4.05948 19.2234 3.59932C20.2024 3.33345 21.0307 3.58909 21.6869 4.31513C22.6443 5.36839 23.3651 6.56481 23.8384 7.87371C24.1719 8.77358 23.9782 9.58142 23.2467 10.2563C22.0096 11.4016 22.0096 12.5674 23.2575 13.7433C23.9782 14.4182 24.1719 15.2261 23.8491 16.1362C23.3651 17.4655 22.612 18.662 21.6439 19.7254C21.0092 20.4106 20.2024 20.6458 19.2664 20.4003C17.5452 19.9402 16.5018 20.5026 16.0392 22.1387C15.781 23.0488 15.1894 23.6215 14.2212 23.8055C12.7474 24.0714 11.2629 24.0816 9.78908 23.8055C8.82091 23.6215 8.21849 23.0386 7.97106 22.1387C7.53001 20.5333 6.48653 19.9606 4.7976 20.4106C4.56093 20.4515 4.34578 20.5026 4.09836 20.4924ZM16.5233 12.5674C16.5018 12.7412 16.5018 12.8537 16.4803 12.9662C15.8671 15.4715 13.1992 16.9133 10.5959 16.1566C9.76757 15.9214 9.1759 16.1566 8.95 16.8315C8.7456 17.4553 9.1006 18.0075 9.89666 18.2325C12.3063 18.9176 14.5009 18.5086 16.4372 16.9951C18.5887 15.3181 19.4386 12.3731 18.5242 9.91888C18.2122 9.09058 17.3409 8.76336 16.7062 9.2951C15.9424 9.9291 15.2324 10.6347 14.5439 11.3505C14.1674 11.7493 14.2427 12.3628 14.63 12.7412C15.0172 13.1196 15.6304 13.1809 16.1037 12.8844C16.2328 12.8026 16.3512 12.7003 16.5233 12.5674ZM7.47622 11.4221C7.48698 11.2789 7.48698 11.1971 7.49773 11.1153C8.05712 8.60997 10.7357 7.09655 13.3175 7.81236C13.5219 7.87371 13.7263 7.94529 13.9415 7.94529C14.4901 7.96574 14.9742 7.57716 15.0818 7.04542C15.1894 6.51368 14.8559 6.01261 14.2319 5.79787C11.7147 4.90822 8.61651 5.67516 6.82001 7.69987C5.14184 9.59165 4.69002 11.7391 5.48608 14.1012C5.76577 14.9295 6.66941 15.2363 7.3041 14.6943C8.05712 14.0603 8.7456 13.3752 9.43408 12.6798C9.8106 12.2913 9.76757 11.7084 9.42333 11.3198C9.06833 10.921 8.48742 10.8085 8.01409 11.0539C7.85273 11.1357 7.70213 11.2687 7.47622 11.4221Z"
                          fill="#4D4D4D"/>
                </svg>
                <span><?php esc_html_e( 'Changelog', 'radio-player' ); ?></span>
            </div>

            <div class="menu-item" data-target="basic-usage">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12.6562 0.00927734C12.6562 1.6024 12.6562 3.12993 12.6562 4.65746C12.6562 5.41654 12.8719 5.63208 13.6312 5.63208C15.1594 5.63208 16.6875 5.63208 18.2812 5.63208C18.2812 6.63481 18.2906 7.60943 18.2719 8.58405C18.2719 8.70588 18.1125 8.83708 18.0094 8.94953C16.5938 10.3646 15.1875 11.7797 13.7625 13.1854C13.2844 13.6539 12.9375 14.1881 12.75 14.8347C12.5813 15.4158 12.3656 15.9874 12.1875 16.5684C11.9812 17.2432 12.1312 17.8429 12.6281 18.3302C13.1344 18.8269 13.7531 18.9769 14.4375 18.7426C14.5969 18.6864 14.7562 18.6301 14.925 18.5739C16.1437 18.1897 17.4 17.8617 18.2438 16.6059C18.2719 16.8589 18.2906 16.9714 18.2906 17.0932C18.2906 18.6395 18.3 20.1858 18.2906 21.732C18.2812 23.119 17.3906 23.9999 15.9938 23.9999C11.4281 23.9999 6.87188 23.9999 2.30625 23.9999C0.88125 23.9905 0 23.119 0 21.7227C0 15.2471 0 8.76211 0 2.27714C0 0.899554 0.88125 0.00927734 2.24062 0.00927734C5.56875 0.00927734 8.89687 0.00927734 12.225 0.00927734C12.3469 0.00927734 12.4688 0.00927734 12.6562 0.00927734ZM8.42813 8.44348C9.99375 8.44348 11.55 8.44348 13.1156 8.44348C13.7062 8.44348 14.0344 8.19046 14.0438 7.75C14.0531 7.30955 13.7156 7.03778 13.1344 7.03778C9.99375 7.03778 6.85312 7.03778 3.7125 7.03778C3.68437 7.03778 3.64687 7.03778 3.61875 7.03778C3.12187 7.05652 2.80312 7.33766 2.8125 7.75C2.82188 8.1436 3.12188 8.44348 3.6 8.44348C5.2125 8.42474 6.81563 8.44348 8.42813 8.44348ZM6.99375 11.2549C8.11875 11.2549 9.24375 11.2549 10.3687 11.2549C10.9031 11.2549 11.2406 10.9737 11.2313 10.5427C11.2219 10.1303 10.9031 9.84918 10.3969 9.84918C8.14688 9.84918 5.89688 9.84918 3.64688 9.84918C3.14063 9.84918 2.82188 10.121 2.8125 10.5427C2.80312 10.9737 3.14062 11.2549 3.66562 11.2549C4.77187 11.2549 5.8875 11.2549 6.99375 11.2549ZM7.03125 14.0663C8.12813 14.0663 9.21562 14.0663 10.3125 14.0663C10.8938 14.0663 11.2312 13.8039 11.2406 13.3634C11.2406 12.923 10.9031 12.6606 10.3219 12.6606C8.11875 12.6606 5.91562 12.6606 3.7125 12.6606C3.15 12.6606 2.80313 12.9417 2.82188 13.3822C2.83125 13.8133 3.15937 14.0663 3.7125 14.0663C4.80937 14.0663 5.91563 14.0663 7.03125 14.0663ZM6.98438 16.8777C8.10938 16.8777 9.23438 16.8777 10.3594 16.8777C10.9031 16.8777 11.2313 16.6059 11.2313 16.1748C11.2313 15.7438 10.8938 15.472 10.3594 15.472C8.1375 15.472 5.925 15.472 3.70312 15.472C3.14062 15.472 2.79375 15.7531 2.8125 16.1936C2.83125 16.6153 3.15 16.8683 3.70312 16.8777C4.8 16.8777 5.8875 16.8777 6.98438 16.8777ZM11.2406 19.6891C10.5656 19.6891 9.9 19.6797 9.225 19.6891C8.71875 19.6985 8.41875 19.9702 8.42813 20.4013C8.4375 20.8324 8.72812 21.0948 9.24375 21.0948C10.575 21.1042 11.8969 21.1042 13.2281 21.0948C13.725 21.0948 14.0531 20.7949 14.0438 20.3826C14.0344 19.9702 13.7156 19.6985 13.2094 19.6891C12.5531 19.6797 11.8969 19.6891 11.2406 19.6891Z"
                          fill="#4D4D4D"/>
                    <path d="M16.941 15.8562C16.3223 15.2377 15.6754 14.5911 15.0566 13.9819C16.5473 12.4919 18.066 10.9737 19.5473 9.50244C20.1473 10.1022 20.8035 10.7582 21.4223 11.3861C19.9598 12.8386 18.4316 14.3662 16.941 15.8562Z"
                          fill="#4D4D4D"/>
                    <path d="M14.0625 4.1796C14.0625 2.80201 14.0625 1.4338 14.0625 0.0374698C14.5781 -0.0281296 15.2719 -0.0375009 15.6281 0.290496C16.4625 1.06832 17.1094 1.78054 17.8688 2.63333C18.1594 2.96133 18.2906 3.2987 18.2906 4.1796C16.7531 4.1796 15.4688 4.1796 14.0625 4.1796Z"
                          fill="#4D4D4D"/>
                    <path d="M20.6621 8.26564C20.9715 7.96576 21.309 7.58154 21.7027 7.25354C22.2652 6.78497 23.1371 6.85994 23.6152 7.36599C24.1121 7.89079 24.1402 8.66861 23.6434 9.23089C23.3152 9.60575 22.9309 9.92437 22.6027 10.2524C21.984 9.61512 21.3465 8.95912 20.6621 8.26564Z"
                          fill="#4D4D4D"/>
                    <path d="M14.0909 15.2002C14.6344 15.7531 15.1498 16.2685 15.6934 16.8214C15.103 17.0182 14.5032 17.2431 13.8847 17.4212C13.5848 17.5055 13.4161 17.215 13.538 16.8496C13.716 16.2966 13.9128 15.7531 14.0909 15.2002Z"
                          fill="#4D4D4D"/>
                </svg>
                <span><?php esc_html_e( 'Basic Usage', 'radio-player' ); ?></span>
            </div>

            <!-- Proxy Player Add-on -->
            <div class="menu-item" data-target="http-player-addon">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="25" viewBox="0 0 100 123" fill="none"><path d="M85.4398 73.2786L14.9706 113.646C8.30404 117.465 0 112.652 0 104.969V24.3474C0 16.9016 7.84611 12.0673 14.4967 15.4154L31.7865 24.1198V53.3418C15.2104 56.4887 11.3234 65.5433 11.8664 73.2401C12.3522 80.1267 17.4877 85.9722 23.947 88.4089C41.1295 94.8908 54.7542 77.8275 54.7542 71.1997C54.7542 67.1297 55.1431 47.3892 55.4524 37.3393L85.7356 56.1006C92.1754 60.0903 92.0131 69.5131 85.4398 73.2786Z" fill="#5C637E"/><path d="M68.2135 0V12.5237L49.652 14.3791V65.4113C49.652 69.2557 49.2983 73.2409 46.8911 76.2384C46.8294 76.3153 46.7671 76.3919 46.7043 76.4682C43.1896 80.7357 38.0407 83.4749 32.5637 84.2283C25.2779 85.2305 20.918 82.8581 18.5084 79.768C15.7226 76.1956 15.905 71.0304 18.0726 67.0523C22.4857 58.9531 32.053 58.0843 37.123 58.9079V2.78305L68.2135 0Z" fill="#5C637E"/></svg>

                <span><?php esc_html_e( 'Proxy Player Addon', 'radio-player' ); ?>
            </div>

            <!-- Ads Player Add-on -->
            <div class="menu-item" data-target="ads-player-addon">

                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet"><g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none"><path d="M4310 4673 c-8 -3 -213 -76 -455 -161 l-440 -156 -340 -7 c-372 -7 -391 -10 -510 -72 -175 -93 -293 -319 -269 -517 10 -79 39 -168 73 -222 l31 -48 -973 0 c-1066 0 -1041 1 -1156 -60 -118 -63 -202 -161 -247 -289 l-24 -66 0 -845 c0 -925 -2 -893 61 -1010 59 -110 159 -195 287 -243 52 -19 82 -21 355 -25 l297 -4 0 -217 c0 -208 1 -220 21 -245 27 -34 62 -48 103 -41 21 4 130 87 336 255 l305 249 555 1 c442 0 569 3 623 15 203 43 366 217 398 427 14 86 8 120 -26 154 -19 18 -35 24 -70 24 -68 0 -99 -34 -108 -117 -12 -116 -79 -212 -182 -263 l-50 -25 -610 -5 c-521 -4 -613 -7 -631 -20 -11 -8 -115 -93 -231 -187 -117 -95 -214 -173 -217 -173 -3 0 -6 68 -6 150 0 158 -9 198 -47 216 -10 5 -175 11 -368 14 l-350 5 -55 26 c-62 30 -123 86 -151 141 -37 72 -40 148 -37 940 l3 765 35 69 c25 49 49 79 85 106 94 72 30 68 1225 66 l1075 -3 76 -299 c67 -264 80 -303 103 -323 26 -22 35 -23 182 -23 l154 0 0 -161 c0 -91 4 -169 10 -180 6 -10 24 -26 40 -34 45 -23 85 -19 122 14 l33 29 3 492 3 492 27 -5 c15 -3 233 -78 484 -166 251 -89 466 -161 478 -161 29 0 77 26 90 49 7 13 10 290 10 818 0 798 0 799 -21 822 -32 34 -73 47 -109 34z m-80 -858 c0 -333 -3 -605 -6 -605 -3 0 -168 57 -365 126 l-359 127 0 351 0 351 358 126 c196 70 360 127 365 128 4 0 7 -271 7 -604z m-940 -1 l0 -325 -267 3 c-265 3 -269 3 -323 29 -79 37 -125 81 -162 157 -28 56 -32 76 -32 137 1 157 115 288 271 315 27 4 153 8 281 9 l232 1 0 -326z m-150 -754 l0 -220 -93 0 -94 0 -55 220 -56 220 149 0 149 0 0 -220z"/><path d="M4803 4463 c-93 -51 -147 -86 -157 -104 -43 -72 7 -159 91 -159 24 0 245 110 305 152 40 28 55 85 34 130 -9 19 -28 40 -42 47 -50 22 -86 12 -231 -66z"/><path d="M4694 3910 c-55 -22 -79 -93 -50 -149 24 -45 52 -51 242 -51 l176 0 29 29 c23 23 29 38 29 71 0 97 -30 110 -242 109 -90 0 -173 -4 -184 -9z"/><path d="M4694 3421 c-56 -24 -79 -94 -49 -150 19 -38 283 -183 336 -185 76 -2 126 73 96 144 -12 30 -34 46 -158 114 -146 79 -187 93 -225 77z"/><path d="M1085 2800 c-11 -4 -30 -18 -41 -31 -30 -33 -394 -993 -394 -1039 0 -66 56 -109 124 -96 46 9 66 37 107 146 l34 90 219 -2 220 -3 36 -94 c40 -104 72 -141 121 -141 63 0 109 45 109 107 0 25 -329 910 -371 1000 -29 61 -102 89 -164 63z m113 -520 c33 -85 62 -165 66 -177 l7 -23 -136 0 c-105 0 -136 3 -133 13 29 80 132 347 134 344 2 -1 30 -72 62 -157z"/><path d="M1914 2789 c-17 -5 -39 -18 -50 -30 -18 -20 -19 -44 -22 -513 -3 -525 -1 -553 45 -583 39 -26 378 -20 467 7 156 49 277 190 323 378 21 88 21 264 0 354 -54 223 -203 365 -407 388 -104 12 -314 11 -356 -1z m417 -235 c85 -47 131 -126 150 -259 24 -179 -42 -350 -160 -409 -38 -19 -67 -24 -158 -28 l-113 -4 0 369 0 370 115 -6 c100 -5 120 -9 166 -33z"/><path d="M3169 1991 c-80 -80 11 -211 116 -167 35 15 65 59 65 96 0 29 -27 77 -49 90 -11 5 -38 10 -61 10 -33 0 -48 -6 -71 -29z"/></g></svg>

                <span><?php esc_html_e( 'Ads Player Addon', 'radio-player' ); ?>
            </div>

            <!-- Help -->
            <div class="menu-item" data-target="help">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_1287_15130)">
                        <path d="M11.9945 0C5.36769 0 0 5.36769 0 11.9945C0 18.6213 5.36769 23.989 11.9945 23.989C18.6213 23.989 23.989 18.6213 23.989 11.9945C23.989 5.36769 18.6213 0 11.9945 0ZM11.8951 22.5532C6.10768 22.5532 1.39162 17.8371 1.40267 12.0387C1.41371 6.27335 6.11873 1.57938 11.884 1.57938C17.6714 1.57938 22.3875 6.29544 22.3764 12.0939C22.3764 17.8481 17.6604 22.5532 11.8951 22.5532Z"
                              fill="#0F1010"/>
                        <path d="M12.1161 5.83157C10.4152 5.78739 9.15614 6.72619 8.73644 8.31662C8.64808 8.64795 8.64808 8.89094 9.07883 8.91302C9.41016 8.93511 9.76359 9.16705 10.0287 9.01243C10.2164 8.91303 10.2385 8.53751 10.349 8.28348C10.6913 7.51036 11.4534 7.09066 12.2707 7.2232C13.1212 7.35573 13.6292 7.86378 13.7286 8.69213C13.7949 9.24436 13.585 9.74137 13.2758 10.1832C12.7567 10.9342 12.2155 11.6742 11.6743 12.4142C11.3982 12.7897 11.2325 13.2094 11.1663 13.6733C11.0006 14.8771 11.0669 14.9324 12.2597 14.9213C12.6131 14.9213 12.7125 14.8109 12.6794 14.4795C12.6131 13.7616 12.8671 13.1652 13.3089 12.6019C13.8059 11.9724 14.2919 11.3097 14.7116 10.6249C16.1363 8.38288 14.7779 5.90888 12.1161 5.83157Z"
                              fill="#0E0E0E"/>
                        <path d="M12.0941 16.2686C11.078 16.3128 11.0669 16.2797 11.078 17.3068C11.078 18.2898 10.9565 18.2125 11.8842 18.2125C12.7899 18.2125 12.7899 18.2125 12.7899 17.2405C12.7899 17.1522 12.7789 17.0528 12.7899 16.9644C12.8893 16.4012 12.6574 16.2465 12.0941 16.2686Z"
                              fill="#181919"/>
                    </g>
                    <defs>
                        <clipPath id="clip0_1287_15130">
                            <rect width="24" height="24" fill="white"/>
                        </clipPath>
                    </defs>
                </svg>
                <span><?php esc_html_e( 'Help', 'radio-player' ); ?></span>
            </div>

			<?php if ( ! rp_fs()->can_use_premium_code__premium_only() ) { ?>
                <div class="menu-item" data-target="get-pro">
                    <svg width="24" height="18" viewBox="0 0 24 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <g clip-path="url(#clip0_1126_11058)">
                            <path d="M11.979 12.8946C8.62624 12.8946 5.27345 12.8849 1.93067 12.9044C1.54034 12.9044 1.44026 12.7877 1.39021 12.4279C0.949848 9.57859 0.489464 6.73904 0.0290807 3.89949C-0.0409777 3.48134 -0.0309694 3.11181 0.379373 2.87842C0.75969 2.65476 1.09997 2.7909 1.43025 3.03402C2.83142 4.06481 4.2526 5.0956 5.66378 6.11667C6.39438 6.64179 6.97487 6.54455 7.47529 5.81521C8.65627 4.09398 9.83725 2.37275 11.0182 0.651519C11.6187 -0.223683 12.3794 -0.223683 12.9899 0.651519C14.1609 2.3533 15.3318 4.06481 16.5028 5.76659C17.0433 6.55427 17.5937 6.65152 18.3744 6.0875C19.7755 5.07615 21.1767 4.06481 22.5679 3.03402C22.8981 2.7909 23.2384 2.65476 23.6187 2.87842C24.0291 3.11181 24.0391 3.48134 23.969 3.89949C23.5787 6.32089 23.1984 8.75201 22.8081 11.1734C22.738 11.6207 22.6379 12.0681 22.6079 12.5154C22.5779 12.8946 22.3577 12.8946 22.0674 12.8946C18.7147 12.8946 15.3418 12.8946 11.979 12.8946Z"
                                  fill="#4D4D4D"/>
                            <path d="M12.0006 14.5771C15.3333 14.5771 18.6661 14.5868 21.9989 14.5674C22.4593 14.5674 22.5594 14.6938 22.5293 15.112C22.4893 15.7051 22.5293 16.3081 22.5193 16.911C22.5093 17.5722 22.119 17.9612 21.4484 18.0098C21.3283 18.0196 21.2182 18.0196 21.0981 18.0196C15.0331 18.0196 8.95803 18.0196 2.89298 18.0196C2.72284 18.0196 2.5627 18.0196 2.39256 17.9904C1.85211 17.9126 1.49181 17.5431 1.4718 17.0082C1.45178 16.3761 1.49181 15.744 1.45178 15.112C1.43176 14.7035 1.52184 14.5674 1.98222 14.5674C5.33501 14.5868 8.66779 14.5771 12.0006 14.5771Z"
                                  fill="#4D4D4D"/>
                        </g>
                        <defs>
                            <clipPath id="clip0_1126_11058">
                                <rect width="24" height="18" fill="white"/>
                            </clipPath>
                        </defs>
                    </svg>
                    <span><?php esc_html_e( 'Get Pro', 'radio-player' ); ?></span>
                </div>
			<?php } ?>

        </div>

		<?php include_once RADIO_PLAYER_INCLUDES . '/views/getting-started/introduction.php'; ?>
		<?php include_once RADIO_PLAYER_INCLUDES . '/views/getting-started/what-new.php'; ?>
		<?php include_once RADIO_PLAYER_INCLUDES . '/views/getting-started/basic-usage.php'; ?>
		<?php include_once RADIO_PLAYER_INCLUDES . '/views/getting-started/proxy-player-addon.php'; ?>
		<?php include_once RADIO_PLAYER_INCLUDES . '/views/getting-started/ads-player-addon.php'; ?>
		<?php include_once RADIO_PLAYER_INCLUDES . '/views/getting-started/help.php'; ?>
		<?php
		if ( ! rp_fs()->can_use_premium_code__premium_only() ) {
			include_once RADIO_PLAYER_INCLUDES . '/views/getting-started/get-pro.php';
		}
		?>

    </div>

</div>

<script>
    jQuery(document).on('ready', function () {
        jQuery('.radio-player-getting-started .menu-item').on('click', function () {
            const target = jQuery(this).data('target');

            jQuery('.menu-item').removeClass('active');
            jQuery('.getting-started-content').removeClass('active');

            jQuery(this).addClass('active');
            jQuery('#' + target).addClass('active');
        });
    });
</script>
