<?php

defined( 'ABSPATH' ) || exit;

class Radio_Player_Hooks {
	/** @var null */
	private static $instance = null;

	/**
	 * Radio_Player_Hooks constructor.
	 */
	public function __construct() {
		// Render the footer sticky player
		add_action( 'wp_footer', [ $this, 'render_player' ] );

		// Popup player
		add_action( 'template_redirect', [ $this, 'render_popup_player' ] );
	}

	/**
	 * Render footer sticky player
	 *
	 * @since 1.0.0
	 */
	public function render_player() {
		if ( rp_fs()->can_use_premium_code__premium_only() ) {

			$display_on_mobile = radio_player_get_setting( 'displayOnMobile', true );

			if ( ! $display_on_mobile && wp_is_mobile() ) {
				return;
			}

			$excludeAll         = radio_player_get_setting( 'excludeAll', false );
			$excludePages       = radio_player_get_setting( 'excludePages', [] );
			$excludeExceptPages = radio_player_get_setting( 'excludeExceptPages', [] );

			global $post;

			$post_id = ! empty( $post->ID ) ? $post->ID : 0;

			if ( is_404() ) {
				$post_id = '404';
			} elseif ( is_search() ) {
				$post_id = 'search';
			} elseif ( is_archive() ) {
				$post_id = 'archive';
			} elseif ( is_home() ) {
				$post_id = 'home';
			} elseif ( is_tag() ) {
				$post_id = 'tag';
			} elseif ( is_category() ) {
				$post_id = 'category';
			}

			if ( $excludeAll ) {
				if ( ! empty( $excludeExceptPages ) && ! in_array( $post_id, $excludeExceptPages ) ) {
					return;
				}
			} else {
				if ( ! empty( $excludePages ) && in_array( $post_id, $excludePages ) ) {
					return;
				}
			}


			$sticky_player = radio_player_get_setting( 'stickyPlayer' );

			if ( ! $sticky_player ) {
				return;
			}

			$player = radio_player_get_players( $sticky_player );

			if ( empty( $player ) ) {
				return;
			}

			echo do_shortcode( '[radio_player id="' . $sticky_player . '" player_type="full-width" ]' );
		}
	}

	/**
	 * Render the popup player
	 *
	 * @since 1.0.0
	 */
	public function render_popup_player() {

		if ( ! empty( $_GET['radio_player'] ) ) {
			$player_id   = intval( $_GET['radio_player'] );
			$player      = radio_player_get_players( $player_id );
			$player_type = 'popup';

			add_filter( 'show_admin_bar', '__return_false' );

			// Remove all WordPress actions
			remove_all_actions( 'wp_head' );
			remove_all_actions( 'wp_print_styles' );
			remove_all_actions( 'wp_print_head_scripts' );
			remove_all_actions( 'wp_footer' );

			// Handle `wp_head`
			add_action( 'wp_head', 'wp_enqueue_scripts', 1 );
			add_action( 'wp_head', 'wp_print_styles', 8 );
			add_action( 'wp_head', 'wp_print_head_scripts', 9 );
			add_action( 'wp_head', 'wp_site_icon' );
			remove_action( 'wp_head', 'wp_auth_check_load' );

			// Handle `wp_footer`
			add_action( 'wp_footer', 'wp_print_footer_scripts', 20 );

			// Handle `wp_enqueue_scripts`
			remove_all_actions( 'wp_enqueue_scripts' );

			// Also remove all scripts hooked into after_wp_tiny_mce.
			remove_all_actions( 'after_wp_tiny_mce' );

			$is_preview     = isset( $_GET['preview'] );
			$header_content = radio_player_get_setting( 'popupHeaderContent' );
			$footer_content = radio_player_get_setting( 'popupFooterContent' );

			?>

            <!doctype html>
            <html lang="<?php language_attributes(); ?>">
            <head>
                <meta charset="<?php bloginfo( 'charset' ); ?>">
                <meta name="viewport"
                      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
                <meta http-equiv="X-UA-Compatible" content="ie=edge">
                <title><?php echo $player['title']; ?></title>

				<?php
				wp_enqueue_style( 'google-font-roboto', 'https://fonts.googleapis.com/css?family=Roboto:400,500,700&display=swap' );
				?>

				<?php do_action( 'wp_head' ); ?>

            </head>

            <body class="radio-player-popup-player-wrap">

			<?php
			if ( ! $is_preview && ! empty( $header_content ) ) {
				printf( '<div class="radio-player-popup-header">%s</div>', do_shortcode( $header_content ) );
			}
			?>

			<?php echo do_shortcode( '[radio_player id="' . $player_id . '" player_type="' . $player_type . '" ]' ); ?>

			<?php
			if ( ! $is_preview && ! empty( $footer_content ) ) {
				printf( '<div class="radio-player-popup-footer">%s</div>', do_shortcode( $footer_content ) );
			}
			?>

			<?php do_action( 'wp_footer' ); ?>

            </body>
            </html>

			<?php
			exit();
		}
	}


	/**
	 * @return Radio_Player_Hooks|null
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}
}

Radio_Player_Hooks::instance();