<?php

defined( 'ABSPATH' ) || exit();

class Radio_Player_Shortcode {

	/**
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Radio_Player_Shortcode constructor.
	 */
	public function __construct() {
		add_action( 'plugins_loaded', array( $this, 'replace_radio_player_shortcode' ) );
	}

	public function replace_radio_player_shortcode() {
		remove_shortcode( 'radio_player' );
		add_shortcode( 'radio_player', array( $this, 'render_player' ) );
	}

	/**
	 * @param $atts
	 *
	 * @return false|string|void
	 * @since 1.0.0
	 */
	public function render_player( $atts ) {

		$is_preview = isset( $_GET['preview'] );

		$atts = shortcode_atts( array(
			'id'          => '',
			'player_type' => 'shortcode',
		), $atts );

		$id = intval( $atts['id'] );

		$player = radio_player_get_players( $id );

		if ( empty( $player['status'] ) && ! $is_preview ) {
			return;
		} elseif ( $is_preview ) {
			if ( ! current_user_can( 'edit_posts' ) ) {
				return;
			}
		}

		$config = $player['config'];

		if ( rp_fs()->can_use_premium_code__premium_only() ) {
			if ( ! $this->check_schedule__premium_only( $config ) ) {
				return;
			}
		}

		$config['id'] = $id;

		// Enqueue frontend scripts
		Radio_Player_Enqueue::instance()->frontend_scripts();

		return sprintf( '<div class="radio_player" data-player-type="%1$s"data-data="%2$s"></div>', esc_attr( $atts['player_type'] ), esc_attr( base64_encode( json_encode( $config ) ) ) );
	}

	public function check_schedule__premium_only( $config ) {
		$displaySchedule = ! empty( $config['displaySchedule'] ) ? $config['displaySchedule'] : 'always';

		if ( 'always' == $displaySchedule ) {
			return true;
		}

		$timezone_string = get_option( 'timezone_string' );
		date_default_timezone_set( ! empty( $timezone_string ) ? $timezone_string : 'UTC' ); // Set the timezone according to your Wordpress setting or default to UTC

		$currentTime = current_time( "H:i" );
		$currentDate = current_time( "d" );
		$currentDay  = strtolower( current_time( "l" ) );

		$dailyTimes = ! empty( $config['dailyTimes'] ) ? $config['dailyTimes'] : [];

		$week_days    = ! empty( $config['scheduleWeekDays'] ) ? $config['scheduleWeekDays'] : [];
		$weekly_times = ! empty( $config['weeklyTimes'] ) ? $config['weeklyTimes'] : [];

		$monthly_dates = ! empty( $config['monthlyDates'] ) ? $config['monthlyDates'] : [];
		$monthly_times = ! empty( $config['monthlyTimes'] ) ? $config['monthlyTimes'] : [];

		switch ( $displaySchedule ) {
			case 'daily':
				foreach ( $dailyTimes as $timeSlot ) {
					if ( $this->is_current_time_in_range( $timeSlot['startTime'], $timeSlot['endTime'], $currentTime ) ) {
						return true;
					}
				}
				break;

			case 'weekly':
				if ( in_array( $currentDay, $week_days ) ) {
					if ( ! empty( $weekly_times[ $currentDay ] ) ) {
						foreach ( $weekly_times[ $currentDay ] as $timeSlot ) {
							if ( $this->is_current_time_in_range( $timeSlot['startTime'], $timeSlot['endTime'], $currentTime ) ) {
								return true;
							}
						}
					} else {
						return true;
					}
				}
				break;

			case 'monthly':
				if ( in_array( $currentDate, $monthly_dates ) ) {
					if ( ! empty( $monthly_times[ $currentDate ] ) ) {
						foreach ( $monthly_times[ $currentDate ] as $timeSlot ) {
							if ( $this->is_current_time_in_range( $timeSlot['startTime'], $timeSlot['endTime'], $currentTime ) ) {
								return true;
							}
						}
					} else {
						return true;
					}
				}
				break;

			default:
				return true;
		}

		return false;
	}

	private function is_current_time_in_range( $start, $end, $current ) {
		// Converts a time to a float, eg. '20:30' becomes '20.5'
		$start   = $this->time_to_decimal( $start );
		$end     = $this->time_to_decimal( $end );
		$current = $this->time_to_decimal( $current );

		// Check if current time is within a range
		if ( $start <= $end ) {
			return $current >= $start && $current <= $end;
		} else {
			// If the start time is greater than the end time, it means the range extends to the next day
			return $current >= $start || $current <= $end;
		}
	}

	private function time_to_decimal( $time ) {
		$parts = explode( ":", $time );

		return $parts[0] + ( $parts[1] / 60 );
	}


	/**
	 * @return Radio_Player_Shortcode|null
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}
}

Radio_Player_Shortcode::instance();